#!/bin/bash

# Check if python3 is installed
if ! command -v python3 &> /dev/null
then
    echo "Python3 ist nicht installiert. Installation wird gestartet..."
    # Installation für Debian/Ubuntu Beispiel (kann für andere Distros angepasst werden)
    sudo apt update && sudo apt install -y python3 python3-pip || {
      echo "Python-Installation fehlgeschlagen. Bitte manuell installieren."
      exit 1
    }
else
    echo "Python3 ist bereits installiert."
fi

# Upgrade pip und Installation Pillow
python3 -m pip install --upgrade pip setuptools wheel
python3 -m pip install Pillow

echo "Python und Pillow wurden erfolgreich installiert."
