﻿from __future__ import annotations
from typing import TYPE_CHECKING
from .Entity import Entity
from .Role import Role
from EnumCollection.RoleType import RoleType

if TYPE_CHECKING:
    from .Role import Role as RoleClass

# Playerklasse -> Repräsentiert der aktiven Spieler
# Erbt Attribute und Funktionen aus Entityklasse
class Player(Entity):
    """
    Spielerklasse, erweitert Entity um eine Role‑Instanz.
    Die Role implementiert rollen­spezifisches Verhalten (Abilities).
    """

    def __init__(self, name, hp, attack, defense, xp, lvl, weapon, role: RoleType):
        """
        Konstruktor

        Args:
            name: Benutzername / Anzeigename
            hp, attack, defense, xp, lvl: Basiswerte
            weapon: Weapon‑Objekt oder None
            role: RoleType Enum — zur Erzeugung des Role‑Objekts verwendet
        """
        super().__init__(name, hp, attack, defense, xp, lvl, weapon)
        # Rolle als Objekt instanziieren (enthält Logik der Fähigkeit)
        self.role = Role(self, role)

    def getRole(self):
        """Gibt das Role‑Objekt des Spielers zurück."""
        return self.role
