﻿from __future__ import annotations
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .Game import Game
    from .Creature import Creature
    from .Player import Player

class GameManagement:
    """
    Minimaler Spielmanager:
    - Hält Referenz auf das aktuell aktive Spiel
    - Bietet Helper‑Methoden zum Starten und Beenden eines Spiels
    - Platzhalter für zukünftige Features (z.B. Skalierung, Matchmaking)
    """

    def __init__(self):
        """Initialisiert den Manager ohne aktives Spiel."""
        self.isActive = False
        self.game = None

    def startGame(self, game: "Game"):
        """Setzt ein Spiel als aktiv und speichert die Referenz."""
        self.isActive = True
        self.game = game

    def isInGame(self) -> bool:
        """Gibt zurück, ob ein Spiel aktiv ist."""
        return self.isActive

    def getGame(self) -> "Game":
        """Gibt das aktuelle Spielobjekt zurück."""
        return self.game

    def prepareGame(self, enemy: "Creature", player: "Player") -> "Creature":
        """
        Gibt das Creatureobjekt zurück, das gegen den Spieler kämpfen wird
        -> wird später vtl. noch implementiert
        """
        return enemy

    def endGame(self):
        """Beendet das Spiel und leert die gespeicherte Referenz."""
        self.isActive = False
        self.game = None
