﻿from __future__ import annotations
from typing import TYPE_CHECKING
import random
from .Entity import Entity
from EnumCollection.AttackType import AttackType


# Typcheck -> Um zirkuläre Imports zu verhindern
if TYPE_CHECKING:
    from .Game import Game


# Creature Klasse -> Repräsentiert den Gegner im Spiel
# Erbt Attribute der Klasse Entity
class Creature(Entity):
    """
    Repräsentiert gegnerische Kreaturen im Spiel.
    Vererbt von Entity und überschreibt attack(), um Gegnerverhalten zu implementieren.
    """

    # Defines Constructor of Creature
    def __init__(self, name, hp, attack, defense, xp, lvl, weapon):
        """
        Konstruktor – leitet an Entity weiter.
        Parameter gleichen denen von Entity.__init__.
        """
        super().__init__(name, hp, attack, defense, xp, lvl, weapon) # Inherited attributes from Entity


    # Angriffsfunktion der Klasse Creature
    def attack(self, target: "Entity", attackType: AttackType, game: "Game"):
        """
        Führt einen Angriff auf das Ziel aus.
        - attackType steuert PRIMARY / SECONDARY / ABILITY.
        - Bei SECONDARY werden sowohl Schaden als auch Boosts wie beim Player angewendet.
        - Am Ende wird der Zug gewechselt.
        """
        attacker = self.getName()
        defender = target.getName()
        
        # AttackType ist eine Aufzählung, bestehend aus PRIMARY, SECONDARY und ABILITY
        if attackType == AttackType.PRIMARY:
            # Schaden des Angreifers, abhängig vom Zusatzschaden der Waffe und dem Statuswert Angriff
            dmg = self.getWeapon().primary() + self.getAttack()
            print(f"{attacker} führt PRIMARY-Angriff auf {defender} aus (Basis-Schaden: {dmg}).")
            # Aufruf der Funktion defend() des vertedigenden Entities
            target.defend(dmg, game)
        elif attackType == AttackType.SECONDARY:
            boosts = self.getWeapon().secondary()
            # Secondary: leichter Schaden + Boosts (wie bei Entity.attack)
            # Versucht Zusatzschaden der Waffe in variable zu speichern
            try:
                # Zusatzschaden der Waffee in Variable speichern
                weapon_primary = int(self.getWeapon().primary())
            except Exception:

                # Wenn Waffe nicht verfügbar, Zusatzschaden der Waffe = 0
                weapon_primary = 0
                # Berechnung vom Schaden des secondary Attack Typs
            sec_damage = int((weapon_primary * 0.5) + (self.getAttack() * 0.5))
            if sec_damage > 0:
                print(f"{attacker} führt SECONDARY-Angriff auf {defender} aus (Schaden: {sec_damage}).")
                target.defend(sec_damage, game)
            if boosts and any(b != 0 for b in boosts):
                print(f"{attacker} erhält Boosts HP {boosts[0]}, ATK {boosts[1]}, DEF {boosts[2]}.")
                self.boost(boosts[0], boosts[1], boosts[2])
        elif attackType == AttackType.ABILITY:
            print(f"{attacker} verwendet ABILITY gegen {defender}.")
            self.getRole().useAbility(game, self, target)
        else:
            print("Ungültiger Angriffstyp!")

        # Wichtig: nach dem Angriff wechseln wir den Zug
        self.switch(game)
